def solve():
    import sys
    input = sys.stdin.read
    data = input().split()

    N, Q = int(data[0]), int(data[1])
    a = list(map(int, data[2:2+N]))

    queries = data[2+N:]
    
    from collections import defaultdict, deque

    count_map = defaultdict(int)
    sum_map = defaultdict(int)
    card_queues = defaultdict(deque)

    total_sum = 0
    total_cards = 0

    for v in a:
        count_map[v] += 1
        sum_map[v] += v
        card_queues[v].append(v)
        total_sum += v
        total_cards += 1

    def add_card(x):
        nonlocal total_sum, total_cards
        count_map[x] += 1
        sum_map[x] += x
        card_queues[x].append(x)
        total_sum += x
        total_cards += 1

    def remove_card(x):
        nonlocal total_sum, total_cards
        val = card_queues[x].popleft()
        count_map[x] -= 1
        sum_map[x] -= val
        total_sum -= val
        total_cards -= 1

    idx = 0
    output = []

    for _ in range(Q):
        t = int(queries[idx])
        idx += 1
        if t == 1:
            x = int(queries[idx])
            idx += 1
            res = total_sum - count_map[x] * x
            output.append(str(res))
        else:
            x, y = int(queries[idx]), int(queries[idx+1])
            idx += 2
            if count_map[x] > 0:
                while card_queues[x]:
                    remove_card(x)
                add_card(y)

    print("\n".join(output))